<?php

// This file keeps track of upgrades to
// the myeducationpath module
//
// Sometimes, changes between versions involve
// alterations to database structures and other
// major things that may break installations.
//
// The upgrade function in this file will attempt
// to perform all the necessary actions to upgrade
// your older installation to the current version.
//
// If there's something it cannot do itself, it
// will tell you what you need to do.
//
// The commands in here will all be database-neutral,
// using the functions defined in lib/ddllib.php

function xmldb_myeducationpath_upgrade($oldversion=0) {

	global $CFG, $THEME, $DB;
	$dbman = $DB->get_manager();

	if(!class_exists('XMLDBTable')){
		class XMLDBTable extends xmldb_table{
		}
	}
	if(!class_exists('XMLDBField')){
		class XMLDBField extends xmldb_field{
			function setAttributes($type, $precision=null, $unsigned=null, $notnull=null, $sequence=null, $enum=null, $enumvalues=null, $default=null, $previous=null){
				return $this->set_attributes($type, $precision, $unsigned, $notnull, $sequence, $default, $previous);
			}
		}
	}
	if(!function_exists('add_field')){
		function add_field($table, $field){
			global $DB;
			$dbman = $DB->get_manager();
			if (!$dbman->field_exists($table, $field)) {
				$dbman->add_field($table, $field);
			}
			return true;
		}
	}
	
	if(!function_exists('create_table')){
		function create_table($table){
			global $DB;
			$dbman = $DB->get_manager();
			echo 'create table';
			print_r($table);
			exit;
			return $dbman->create_table($table);
		}
	}

	$result = true;

	if ($result && $oldversion < 2013121404) {
		// Add new fields to certificate table
		$table = new XMLDBTable('myeducationpath');
		$field = new XMLDBField('emailteachers');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '2', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'imageurl');
		$result = $result && add_field($table, $field);

		$field = new XMLDBField('emailothers');
		$field->setAttributes(XMLDB_TYPE_TEXT, 'small', null, null, null, null, null, null, 'emailteachers');
		$result = $result && add_field($table, $field);

		$field = new XMLDBField('certificateidformat');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '2', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'emailothers');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('certificatecustomformat');
		$field->setAttributes(XMLDB_TYPE_TEXT, 'small', null, null, null, null, null, null, 'certificateidformat');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('coursehours');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'certificatecustomformat');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('certificatetime');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'coursehours');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('lastnumber');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'certificatetime');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('certificateassigndate');
		$field->setAttributes(XMLDB_TYPE_TEXT, 'small', null, null, null, null, null, null, 'lastnumber');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('certificateenddate');
		$field->setAttributes(XMLDB_TYPE_TEXT, 'small', null, null, null, null, null, null, 'certificateassigndate');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('allowautoissue');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '2', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'certificateenddate');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('minimumgrade');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'allowautoissue');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('emailstudent');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '2', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'minimumgrade');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('timemodified');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'emailstudent');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('certificatetemplate');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'timemodified');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('certificateinfo');
		$field->setAttributes(XMLDB_TYPE_TEXT, 'small', null, null, null, null, null, null, 'certificatetemplate');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('allowcertificates');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '2', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'certificateinfo');
		$result = $result && add_field($table, $field);
		
		$field = new XMLDBField('mepcourseidmanual');
		$field->setAttributes(XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, null, null, '0', 'allowcertificates');
		$result = $result && add_field($table, $field);
	
		//create new table
		global $DB;
		$DB->execute('CREATE TABLE IF NOT EXISTS `'.$CFG->prefix.'myeducationpath_issues` ('.
			'`id` bigint(10) NOT NULL AUTO_INCREMENT,'.
			'`certificateid` bigint(10) NOT NULL DEFAULT \'0\','.
			'`userid` bigint(10) NOT NULL DEFAULT \'0\','.
			'`timecreated` bigint(10) NOT NULL DEFAULT \'0\','.
			'`studentname` varchar(40) NOT NULL DEFAULT \'\','.
			'`code` varchar(40) DEFAULT NULL,'.
			'`classname` varchar(254) NOT NULL DEFAULT \'\','.
			'`certdate` bigint(10) DEFAULT \'0\','.
			'`reportgrade` varchar(10) DEFAULT NULL,'.
			'`mailed` tinyint(1) NOT NULL DEFAULT \'0\','.
			'`cwcertid` bigint(10) NOT NULL DEFAULT \'0\','.
			'`cwuserid` bigint(10) NOT NULL DEFAULT \'0\','.
			'`cwlink` varchar(255) NOT NULL DEFAULT \'\','.
			'PRIMARY KEY (`id`)'.
			')');

		upgrade_mod_savepoint(true, 2013121404, 'myeducationpath');
	}
	
	return $result;
}

?>