<?php

// This file is part of MyEducationPath module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/// This page returns XML with all courses on this server

require_once('../../config.php');
require_once('lib.php');
global $CFG,$SITE,$DB;

//firstly, check if settings are configured to return the list or not

//inlude the class to generate XML 
include_once('lib/XmlWriter.class.php');

$xml = new XmlWriterPure();//xml generator object

$xml->push('coursesfeed');//create root node

$xml->push('vendor');//create vendor description node
$xml->element('name',$SITE->fullname);
$xml->element('description',$SITE->summary,true);
$xml->element('website',$CFG->wwwroot,true);
$xml->element('logourl',$CFG->wwwroot,true);
$xml->pop();//close vendor tag
	
//this is direct access to the page
//check if it is allowed to list courses
if($CFG->myeducationpath_enableintegration=='yes'){
	$xml->element('exportdisabled','n');
	
	//$courses = get_courses_wmanagers('all','c.sortorder ASC',array('summary','summaryformat'));
	$courses=myeducationpath_get_allcourse_with_activity();
		//add courses
	foreach($courses as $c){
		$course = $DB->get_record('course', array('id'=> $c->course));
		if(!$course) continue;
		if($course->visible!=1) continue;
		
		$xml->push('course');//create course node
		$xml->element('id',$course->id);
		$xml->element('title',$course->fullname);
		$xml->element('link',$CFG->wwwroot.'/course/view.php?id='.$course->id);
		$image='';
		if($c->imageurl!=''){
			$image=$c->imageurl;
		}elseif(file_exists(dirname(__FILE__).'/images/'.$course->id.'.jpg')){
			$image=$CFG->wwwroot.'/mod/myeducationpath/images/'.$course->id.'.jpg';
		}elseif(file_exists(dirname(__FILE__).'/images/'.$course->id.'.png')){
			$image=$CFG->wwwroot.'/mod/myeducationpath/images/'.$course->id.'.png';
		}
		$xml->element('imagelink',$image);
		$xml->element('description',$course->summary,true);
		
		if($c->tags!=''){
			foreach(split(',',$c->tags) as $tag){
				$xml->element('tag',trim($tag));
			}
		}
		
		$startdate=date('Y-m-d',$course->startdate);
		
		$duration='';
		
		$price='';
		$lowestcost='';
		$lowestsymbol='';
		
		$allowenroll='y';
		$instances = enrol_get_instances($c->course, false);
		foreach($instances as $i){
			if($i->status!=0) continue;
			if($i->enrol=='manual' || $i->enrol=='guest') continue;
			if($lowestcost=='' || $lowestcost!='' && ($i->cost=='' || $i->cost<$price)){
				$lowestcost=$i->enrol;
				$price=$i->cost;
				$lowestsymbol=$i->currency;		
				if($price==''){
					break;//no sence to check more as this is lowest price
				}
			}
		}
		if($price!='' && $lowestsymbol!='') $price.=' '.$lowestsymbol;
		
		if($course->format=='weeks'){
			
			$duration=$course->numsections.' weeks';
		}
		$xml->element('startdate',$startdate);
		$xml->element('duration',$duration);
		$xml->element('price',$price);
		$xml->element('allowenroll',$allowenroll);
		
		$xml->pop();//close course node
	}
}else{
	$xml->element('exportdisabled','y');
}
$xml->pop();//close root node

header('Content-type: application/xml');
print $xml->getXml();//output XML
