<?php

class SimpleCache {
	var $_cache_directory;
	var $_cacheactive=0;
	var $_cachetime=3600;
	var $_secureprefix;

	function __construct($path='',$active=1,$time=1800,$sequre='securetext'){
		$this->_cache_directory=$path;
		$this->_cacheactive=$active;
		$this->_cachetime=$time;
		if($sequre!=''){
			$this->_secureprefix=md5($sequre).'.txt';
		}else{
			$this->_secureprefix='.txt';
		}
	}
	
	function setOnOff($active){
		$this->_cacheactive=$active;
	}
	
	function setTime($time){
		$this->_cachetime=$time;
	}
	
	function cacheFileExists($file,$exptime=0){
		if($exptime==0) $exptime=$this->_cachetime;
		if($this->_cacheactive!=1) return false;
		$path=$this->_cache_directory.$file.$this->_secureprefix;
		if(!file_exists($path) || time()-filectime($path)>$exptime){
			if(file_exists($path))
				unlink($path);
			return false;
		}
		return true;
	}
	function getFilePath($file){
		return $this->_cache_directory.$file.$this->_secureprefix;
	}
	function removeCacheFile($file){
		if($this->_cacheactive!=1) return false;
		$path=$this->_cache_directory.$file.$this->_secureprefix;
		if(file_exists($path)) unlink($path);
		return true;
	}
	function removeFilesStartingWith($pref){
		if($this->_cacheactive!=1) return false;
		if ($handle = opendir($this->_cache_directory)) {
			while (false !== ($entry = readdir($handle))) {
				if(preg_match('!^'.preg_quote($pref).'!',$entry))
					unlink($this->_cache_directory.$entry);
			}

			closedir($handle);
		}
	}
	function getCachedFile($file,$decode=0,$exptime=0){
		if(!$this->cacheFileExists($file,$exptime)){
			if($decode==1) return null;
			return '';
		}
		$path=$this->_cache_directory.$file.$this->_secureprefix;
		if(file_exists($path)){

			$data=file_get_contents($path);
			if($decode==1){
				$data=json_decode($data);
			}
			return $data;
		}
		if($decode==1) return null;
		return '';
	}
	
	function cacheFile($file,$body,$encode=0){
		$path=$this->_cache_directory.$file.$this->_secureprefix;
		if(file_exists($path))
			unlink($path);
		if($encode==1){
			$body=json_encode($body);
		}

		file_put_contents($path,$body);
	}
	
	function getFullFilePath($file){
		return $this->_cache_directory.$file.$this->_secureprefix;
	}
	
	function object_to_array($object)
	{

		if(is_array($object) || is_object($object))
		{
			$array = array();
			foreach($object as $key => $value)
			{
				$array[$key] = $this->object_to_array($value);
			}
			return $array;
		}
		return $object;
	}
}

?>