<?php
/**

 * the class MyEducationPath implements API functionality for education providers
 * the class requires an API key to work. The key can be get on http://myeducationpath.com 

 */
class MyEducationPath {
	var $apiendpoint='http://myeducationpath.com/api/';
	var $apikey='';
	var $error='';
	var $errorcode=0;
	var $errorstatus='';
	var $templateid='0';
	var $courseidtype='local';
	var $emailuser=false;
	var $useragent='MyEducationPath.com API PHP client';
	var $debug=0;
	function __construct($apikey='')
	{
		$this->apikey=$apikey;
	}
	function checkAPIKey(){
		if($this->apikey=='') return false;
		$resp=$this->executeAPICall('getAccountInfo');
		if($resp->status!='ok') return false;
		return true;
	}
	function executeAPICall($function,$options=''){
		$url=$this->apiendpoint.$function.'/'.urlencode($this->apikey).'/';
		$url.='?'.$options;
		
		$this->error='';
	
		if($this->debug>0){
			echo $url.'<br>';
		}
		
		if(function_exists('curl_init')){
			  $ch = curl_init();
			  curl_setopt($ch, CURLOPT_URL, $url);
			  curl_setopt($ch, CURLOPT_USERAGENT, $this->useragent);
			  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			  curl_setopt($ch, CURLOPT_TIMEOUT, 20);
			  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
	
			  $result = curl_exec ($ch);
	
			  if (curl_error($ch)) { 
				$this->error=curl_error($ch);
				$result="";
			  } 
			  curl_close ($ch);
		}else{
			  $result=file_get_contents($url);
		}
		if(trim($result)==''){
			if($this->error=='')
				$this->error='API request failed';
			return null;
		}
		if(substr($result,0,1)!='{'){
			$r=new Object();
			$r->status='error';
			$r->message='Wrong API response';
		}else{
			$r=json_decode($result);
		}
		
		$this->errorcode=0;
		if($r->status!='ok'){
			$this->error=$r->message;
			$this->errorstatus=$r->status;
			if($r->status=='error_api_key'){
				$this->errorcode=1;
			}
			return $r;
		}
		return $r;
	}
	function setTemplateID($id){
		$this->templateid=$id;
	}
	function setEmailUser($s){
		$this->emailuser=$s;
	}
	function setCourseType($t){
		if($t!='local') $t='remote';
		$this->courseidtype=$t;
	}
	function getCertificates(){
		$resp=$this->executeAPICall('getCertificates');
		if($resp->status=='ok') return $resp->response->certificates;	
		return null;
	}
	function getTemplates(){
		$resp=$this->executeAPICall('getTemplates');
		if($resp->status=='ok') return $resp->response->templates;
		return null;	
	}
	
	function getCertificate($id){
		$resp=$this->executeAPICall('getCertificate','id='.$id);
		if($resp->status=='ok') return $resp->response->certificate;
		return null;		
	}	
	function checkCourseExistsByRemoteID($id){
		$coursedata=$this->executeAPICall('checkCourse','id='.$id);
		if($coursedata->status!='ok'){
			return false;
		}
		if($coursedata->response->exists=='y') return true;
		return false;
	}
	function addCertificate($courseid,$email,$name,$date,$code='',$programshort='',$hours='',$enddate='',$grade='',$teacher='',$courseidtype=''){
		if($courseidtype=='') $courseidtype=$this->courseidtype;
		$options='email='.urlencode($email).
			'&code='.urlencode($code).
			'&name='.urlencode($name).
			'&date='.urlencode($date).
			'&programshort='.urlencode($programshort).
			'&coursehours='.urlencode($hours).
			'&enddate='.urlencode($enddate).
			'&grade='.urlencode($grade).
			'&teacher='.urlencode($teacher).
			'&templateid='.urlencode($this->templateid).
			'&courseid='.urlencode($courseid).
			'&emailuser='.($this->emailuser?'y':'n').
			'&courseidtype='.$courseidtype;
		$resp=$this->executeAPICall('addCertificate',$options);

		if($resp->status=='ok') return $resp->response->certificate;
		return false;
	}
	
	function removeCertificate($certificateid){
		$options='id='.urlencode($certificateid);
		$resp=$this->executeAPICall('deletecertificate',$options);
		if($resp->status=='ok') return true;
		return false;
	}
	function getPrintCertificateLink($certificateid){
		$options='id='.urlencode($certificateid);
		$resp=$this->executeAPICall('getcertificate',$options);
		if($resp->status=='ok') return $resp->response->certificate->printlink;
		return '';
	}
	function getVendorInformation($demoimagedata=''){
		$resp=$this->executeAPICall('getAccountInfo',$demoimagedata);
		if($resp->status=='ok') return $resp->response->account;
		return null;
	}
	function getCategories(){
		$resp=$this->executeAPICall('getCategories');
		if($resp->status=='ok') return $resp->response->categories;
		return array();
	}
	function addCourse($importid,$name,$description,$url,$imgurl,$price,$duration,$startdate,$tags,$categories){
		
		$coursedata=$this->executeAPICall('addCourse','id='.$importid.
			'&name='.urlencode($name).
			'&description='.urlencode($description).
			'&weburl='.urlencode($url).
			'&imageurl='.urlencode($imgurl).
			'&price='.urlencode($price).
			'&duration='.urlencode($duration).
			'&startdate='.urlencode($startdate).
			'&tags='.urlencode($tags).
			'&categories='.$categories
			);
		if($coursedata->status!='ok'){
			$this->errorcode=2;
			return null;
		}
		return $coursedata->response->course;
	}
	function getCourse($id,$idtype='local'){
		$resp=$this->executeAPICall('getcourse','id='.$id.'&idtype='.$idtype);
		if($resp->status=='ok') return $resp->response->course;
		return null;
	}
	function commentCourse($courseid,$comment,$commentid,$username){
		$resp=$this->executeAPICall('commentcourse','courseid='.$courseid.'&comment='.urlencode($comment).
			'&commentid='.urlencode($commentid).'&username='.urlencode($username)
			);
		
		if($resp->status=='ok') return $resp->response->comment;
		return false;
	}
	function rateCourse($courseid,$userid,$rating){
		$resp=$this->executeAPICall('ratecourse','courseid='.$courseid.'&userid='.urlencode($userid).'&rating='.urlencode($rating));
		
		if($resp->status=='ok') return true;
		return false;
	}
	function getErrorCode(){
		return $this->errorcode;
	}
}

?>