<?php

class MEPHelper {
	var $CFG;
	var $SITE;
	var $DB;
	var $USER;
	var $CM;
	var $course;
	var $mepinstance;	
	function __construct($CFG,$SITE,$DB,$USER,$course,$mepinstance,$cm)
	{
		$this->CFG=$CFG;
		$this->SITE=$SITE;
		$this->USER=$USER;
		$this->DB=$DB;
		$this->CM=$cm;
		$this->course=$course;
		$this->mepinstance=$mepinstance;
	}
	function getCoursePrice($c=null){
		if(!$c) $c=$this->course;
		
		$price='';
		$lowestcost='';
			
		$allowenroll='y';
		$instances = enrol_get_instances($c->id, false);
		foreach($instances as $i){
			if($i->status!=0) continue;
			if($i->enrol=='manual' || $i->enrol=='guest') continue;
			if($lowestcost=='' || $lowestcost!='' && ($i->cost=='' || $i->cost<$price)){
				$lowestcost=$i->enrol;
				$price=$i->cost;		
				if($price==''){
					break;//no sence to check more as this is lowest price
				}
			}
		}
		return $price;
	}
	function generateCode($user=null) {
		if(!$user) $user=$this->USER;
		if($this->mepinstance->certificateidformat==1 && $this->mepinstance->certificatecustomformat!=''){
			if(strpos($this->mepinstance->certificatecustomformat,'%')!==FALSE){
				//generate code
				//Y - current year,<br>M - current month,<br>D - current day,<br>S - student ID in system,<br>C - course ID,<br>N - number of certificate in course.
				$code=$this->mepinstance->certificatecustomformat;
				$code=preg_replace('!%Y!',date('Y'),$code);
				$code=preg_replace('!%M!',date('m'),$code);
				$code=preg_replace('!%D!',date('d'),$code);
				$code=preg_replace('!%S!',$user->id,$code);
				$code=preg_replace('!%C!',$this->course->id,$code);
				$code=preg_replace('!%N!',($this->mepinstance->lastnumber+1),$code);
				return $code;
			}
		}
		return (random_string(10));
	}
	function getCourseGrade($user=null){
		if(!$user) $user=$this->USER;
		if ($course_item = grade_item::fetch_course_item($this->course->id)) {
			$grade = new grade_grade(array('itemid'=>$course_item->id, 'userid'=>$user->id));
			
			$course_item->gradetype = GRADE_TYPE_VALUE;
			
			$coursegrade=new Object();
	
			$coursegrade->points = grade_format_gradevalue($grade->finalgrade, $course_item, true, GRADE_DISPLAY_TYPE_REAL, $decimals=2);
			
			$coursegrade->percentage = grade_format_gradevalue($grade->finalgrade, $course_item, true, GRADE_DISPLAY_TYPE_PERCENTAGE, $decimals=2);
			
			$coursegrade->letter = grade_format_gradevalue($grade->finalgrade, $course_item, true, GRADE_DISPLAY_TYPE_LETTER, $decimals=0);
			
			return $coursegrade;
		}
		
		return false;
	}
	function getTeachersForCourse(){
		if($this->CFG->branch>='26'){
			$context = context_module::instance($this->CM->id);
		}else{
			$context = get_context_instance(CONTEXT_MODULE, $this->CM->id);
		}

		$teachername='';
		$teacherslist=array();
	
		if($context){
			if ($teachers = get_users_by_capability($context, 'mod/myeducationpath:printteacher', '', $sort='u.lastname ASC','','','','',false)) {
				foreach ($teachers as $teacher) {
					$teacherslist[]=fullname($teacher);
					if($teachername=='') $teachername=fullname($teacher);
				}
			}
		}
		return array($teachername,$teacherslist);
	}
	function getTeachers($user=null) {
		if(!$user) $user=$this->USER;
		
		if($this->CFG->branch>='26'){
			$context = context_module::instance($this->CM->id);
		}else{
			$context = get_context_instance(CONTEXT_MODULE, $this->CM->id);
		}	

		$potteachers = get_users_by_capability($context, 'mod/myeducationpath:manage', '', '', '', '', '', '', false, false);
		if (empty($potteachers)) {
			return array();
		}
		$teachers = array();
		if (groups_get_activity_groupmode($this->CM, $this->course) == SEPARATEGROUPS) {   // Separate groups are being used
			if ($groups = groups_get_all_groups($course->id, $user->id)) {  // Try to find all groups
				foreach ($groups as $group) {
					foreach ($potteachers as $t) {
						if ($t->id == $user->id) {
							continue; // do not send self
						}
						if (groups_is_member($group->id, $t->id)) {
							$teachers[$t->id] = $t;
						}
					}
				}
			} else {
				foreach ($potteachers as $t) {
					if ($t->id == $this->USER->id) {
						continue; // do not send self
					}
					if (!groups_get_all_groups($this->course->id, $t->id)) { //ugly hack
						$teachers[$t->id] = $t;
					}
				}
			}
		} else {
			foreach ($potteachers as $t) {
				if ($t->id == $this->USER->id) {
					continue; // do not send self
				}
				$teachers[$t->id] = $t;
			}
		}
		
		return $teachers;
	}
	function emailTeachers($certrecord) {
		if ($this->mepinstance->emailteachers == 0) {
			return;
		}
		$student = $certrecord->studentname;
		$user = $this->DB->get_record('user', array('id'=> $certrecord->userid));

		if ($teachers = $this->getTeachers($user)) {
			$strawarded  = get_string('awarded', 'myeducationpath');
			foreach ($teachers as $teacher) {
				unset($info);

				$info->student = $student;
				$info->course = format_string($this->course->fullname,true);
				$info->certificate = format_string($this->mepinstance->name,true);
				$info->url = $this->CFG->wwwroot.'/mod/myeducationpath/report.php?id='.$this->CM->id;
				$from = $student;
				$postsubject = $strawarded.': '.$info->student.' -> '.$this->mepinstance->name;
				$posttext = get_string('emailteachermail', 'myeducationpath', $info)."\n";
				if($teacher->mailformat == 1){
					$posthtml  = '<font face="sans-serif">';
					$posthtml .= '<p>'.get_string('emailteachermailhtml', 'myeducationpath', $info).'</p>';
					$posthtml .= '</font>';
				};

				@email_to_user($teacher, $from, $postsubject, $posttext, $posthtml);  // If it fails, oh well, too bad.
			}
		}
	}

	function emailStudent($certrecord,$user) {
		if ($this->mepinstance->emailstudent == 0) {
			return;
		}
		$strawarded  = get_string('awarded', 'myeducationpath');
		unset($info);
		
		$info->student = fullname($user);
		$info->course = format_string($this->course->fullname,true);
		$info->certificate = format_string($this->mepinstance->name,true);
		$info->url = $certrecord->cwlink;
		$from = $this->SITE->fullname;
		$postsubject = $strawarded.': '.$info->student.' -> '.$this->mepinstance->name;
		
		$posttext = get_string('emailstudentmail', 'myeducationpath', $info)."\n";
		
		$posthtml = '';
		if($user->mailformat == 1){
			$posthtml  = '<font face="sans-serif">';
			$posthtml .= '<p>'.get_string('emailstudentmailhtml', 'myeducationpath', $info).'</p>';
			$posthtml .= '</font>';
		}
		
		@email_to_user($user, $from, $postsubject, $posttext, $posthtml);  // If it fails, oh well, too bad.
	}

	function emailOthers($certrecord) {
		
		if ($this->mepinstance->emailothers) {
			$student = $certrecord->studentname;
			
			$others = explode(',', $this->mepinstance->emailothers);
			if ($others) {
				$strawarded  = get_string('awarded', 'myeducationpath');
				foreach ($others as $other) {
					$other = trim($other);
					if (validate_email($other)) {
						$destination->email = $other;
						unset($info);
						$info->student = $student;
						$info->course = format_string($this->course->fullname,true);
						$info->certificate = format_string($certificate->name,true);
						$info->url = $this->CFG->wwwroot.'/mod/myeducationpath/report.php?id='.$this->CM->id;
						$from = $student;
						$postsubject = $strawarded.': '.$info->student.' -> '.$this->mepinstance->name;

						$posttext = get_string('emailteachermail', 'myeducationpath', $info)."\n";
				
						$posthtml  = '<font face="sans-serif">';
						$posthtml .= '<p>'.get_string('emailteachermailhtml', 'myeducationpath', $info).'</p>';
						$posthtml .= '</font>';
						
						@email_to_user($destination, $from, $postsubject, $posttext, $posthtml);  // If it fails, oh well, too bad.
					}
				}
			}
		}
	}
}

?>