<?php

require_once('myeducationpath.php');
require_once('class.cache.php');
require_once('myeducationpath_helper.php');

class MEPWrapper extends MyEducationPath {
	var $CFG;
	var $SITE;
	var $DB;
	var $USER;
	var $CM;
	var $MYEDUPATHFILECACHE=null;
	var $course;
	var $mepinstance;
	var $certrecord;
	var $user;
	var $helper=null;	
	function __construct($CFG,$SITE,$DB,$USER,$course,$mepinstance,$cm)
	{
		$this->useragent="Moodle plugin from ".$CFG->wwwroot;
		parent::__construct($CFG->myeducationpath_apikey);
		$this->CFG=$CFG;
		$this->SITE=$SITE;
		$this->USER=$USER;
		$this->DB=$DB;
		$this->CM=$cm;
		$this->course=$course;
		$this->mepinstance=$mepinstance;
		if(defined('_MYEDUCATIONPATH_ENDPOINT')){
			$this->apiendpoint='http://'._MYEDUCATIONPATH_ENDPOINT.'/api/';
		}else{
			define('_MYEDUCATIONPATH_ENDPOINT','myeducationpath.com');
		}
	}
	function loadHelper(){
		if($this->helper) return true;
		$this->helper=new MEPHelper($this->CFG,$this->SITE,$this->DB,$this->USER,$this->course,$this->mepinstance,$this->CM);
		return $this->helper;
	}
	function setCertRecord($certrecord){
		$this->certrecord=$certrecord;
	}
	function setUserRecord($user){
		$this->user=$user;
	}
	function getMEPCourseID(){
		if($this->mepinstance->mepcourseidmanual>0) return $this->mepinstance->mepcourseidmanual;
		return $this->mepinstance->mepcourseid;
	}
	function getCacheObject(){
		if(isset($this->MYEDUPATHFILECACHE)) return $this->MYEDUPATHFILECACHE;
		$cachepath=$this->CFG->dataroot.'/cache/myeducationpath/';
		if(!is_dir($cachepath)){
			if(is_dir($this->CFG->dataroot.'/cache/')){
				mkdir($cachepath);
			}else{
				return null;
			}
		}
		$this->MYEDUPATHFILECACHE=new SimpleCache($cachepath,1,3600,'');
		return $this->MYEDUPATHFILECACHE;
	}
	function getAllCategories(){
		$cache = $this->getCacheObject();
		if($cache){
			$data = $cache->getCachedFile('categories',1);
			if($data){
				return $data;
			}
		}
		$categories=array();
		$list=$this->getCategories();
		foreach($list as $cat){
			$categories[$cat->id]=$cat->title;
		}
		if($cache){
			$cache->cacheFile('categories',$categories,1);
		}
		return $categories;
	}
	function checkCourseExistsByRemoteID($id=0){
		if($id==0) $id=$this->course->id;
		return parent::checkCourseExistsByRemoteID($id);
	}
	function getAccountInfo(){
		$demoimagedata='courseid='.$this->getMEPCourseID().'&programshort='.urlencode($this->course->shortname).
			'&templateid='.$this->mepinstance->certificatetemplate;
		$key=md5($demoimagedata);
		$cache = $this->getCacheObject();
		if($cache){
			$data = $cache->getCachedFile($key,1,300);
			if($data){
				return $data;
			}
		}
		
		$r=$this->getVendorInformation($demoimagedata);
		if($cache){
			$cache->cacheFile($key,$r,1);
		}
		return $r;
	}
	function getMEPCourse(){
		if($this->mepinstance->mepcourseid>0 || $this->mepinstance->mepcourseidmanual>0){
			if($this->mepinstance->mepcourseinfo!='' && $this->mepinstance->infolastcheck+3600*24<time()){
				return json_decode($this->mepinstance->mepcourseinfo);
			}
			//get the course info and save in DB
			$info=$this->getCourse($this->getMEPCourseID());
			if($info){
				$this->mepinstance->mepcourseinfo=json_encode($info);
				$this->mepinstance->mepcourseid=$info->id;
				$this->mepinstance->infolastcheck=time();
				$this->DB->update_record('myeducationpath', $this->mepinstance);
				
				return $info;
			}
			//re-export the course if it is not found on the server
			return $this->exportCourse();
		}
		//check if this course exists by remote ID
		$info=$this->getCourse($this->course->id,'remote');
		if($info){
			$this->mepinstance->mepcourseinfo=json_encode($info);
			$this->mepinstance->mepcourseid=$info->id;
			$this->mepinstance->infolastcheck=time();
			$this->DB->update_record('myeducationpath', $this->mepinstance);
				
			return $info;
		}
		$this->error='Course is not found on MyEducationPath.com directory.';
		return null;
	}
	function exportCourse(){
		$this->loadHelper();
		
		$duration='';
		if($this->course->format=='weeks'){
			$duration=$this->course->numsections.' weeks';
		}
		$categories=array();
		if($this->mepinstance->category1>0) $categories[]=$this->mepinstance->category1;
		if($this->mepinstance->category2>0) $categories[]=$this->mepinstance->category2;
		if($this->mepinstance->category3>0) $categories[]=$this->mepinstance->category3;
		if(count($categories)>0) $categories=join(',',$categories);
		else $categories='';
	
		$mepcourse=$this->addCourse($this->course->id,$this->course->fullname,$this->course->summary,
			$this->CFG->wwwroot.'/course/view.php?id='.$this->course->id,
			$this->mepinstance->imageurl,$this->helper->getCoursePrice(),
			$duration,date('Y-m-d',$this->course->startdate),$this->mepinstance->tags,$categories);
		
		if(!$mepcourse) return null;
		
		//save this course to local cache
		$this->mepinstance->mepcourseinfo=json_encode($mepcourse);
		$this->mepinstance->mepcourseid=$mepcourse->id;
		$this->mepinstance->infolastcheck=time();
		$this->DB->update_record('myeducationpath', $this->mepinstance);
		
		return $mepcourse;
	}
	function addComment($comment,$rating){
		//check if the course is mapped
		if($this->mepinstance->mepcourseid==0){
			$this->error='Course is not registered';
			return false;
		}
		$mepcommentid=0;
		if ($this->DB->record_exists('myeducationpath_comments', array('activityid'=>$this->mepinstance->id, 'userid'=>$this->USER->id))) {
			$commentrec = $this->DB->get_record('myeducationpath_comments', array('activityid'=>$this->mepinstance->id, 'userid'=>$this->USER->id));
			if($commentrec)
				$mepcommentid=$commentrec->mepcommentid;
		}
		
		//post the comment to MEP first
		
		$commentdata=$this->commentCourse($this->mepinstance->mepcourseid,$comment,$mepcommentid,fullname($this->USER));
		if(!$commentdata){
			return false;
		}
	
		$mepcommentid=$commentdata->id;
		
		if(!$this->rateCourse($this->mepinstance->mepcourseid,$this->USER->id,$rating)){
			return false;
		}
		//check if record for this user and this instance exists
		if (!$this->DB->record_exists('myeducationpath_comments', array('activityid'=>$this->mepinstance->id, 'userid'=>$this->USER->id))) {
			//insert activity
			$newrec = new Object();
			$newrec->courseid = $this->course->id;
			$newrec->activityid = $this->mepinstance->id;
			$newrec->userid = $this->USER->id;
			$newrec->timecreated = time();
			$newrec->mepcommentid = $mepcommentid;
			$newrec->mepcomment = $comment;
			$newrec->mepcommentlastcheck = time();
			$newrec->meprating = $rating;
	
			$this->DB->insert_record('myeducationpath_comments', $newrec, false);
		}else{
			$commentrec = $this->DB->get_record('myeducationpath_comments', array('activityid'=>$this->mepinstance->id, 'userid'=>$this->USER->id));
			$commentrec->mepcommentid = $mepcommentid;
			$commentrec->mepcomment = $comment;
			$commentrec->mepcommentlastcheck = time();
			$commentrec->meprating = $rating;
			$this->DB->update_record('myeducationpath_comments', $commentrec);
		}
	}
	
	function issueCertificate($userid=0,$autoissue=false) {
		if($userid>0){
			$user = $this->DB->get_record("user", array("id"=>$userid));
			if(!$user){
				$this->error='User ID was incorrect';
				return false;
			}
		}else{
			$user=$this->USER;
		}
		
		if ($this->DB->record_exists('myeducationpath_issues', array('certificateid'=>$this->mepinstance->id, 'userid'=>$user->id))) {
			$certrecord = $this->DB->get_record('myeducationpath_issues', array('certificateid'=>$this->mepinstance->id, 'userid'=>$user->id));
			if($certrecord){
				//delete existent certificate and issue new
				$this->issueDelete($certrecord->id);
			}
		}
				
		$this->loadHelper();
	
		list($teachername,$teacherslist)=$this->helper->getTeachersForCourse();
		
		$dateformat=($this->CFG->myeducationpath_dateformat!='')?$this->CFG->myeducationpath_dateformat:'F d, Y';
	
		$code = $this->helper->generateCode($user);
		
		$grade = $this->helper->getCourseGrade($user);
		$grade=($grade)?$grade->percentage:'';
		
		$certtime=time();
		$coursedate=date($dateformat,$certtime);
		if($this->mepinstance->certificateassigndate!='') $coursedate=$this->mepinstance->certificateassigndate;
		
		$enddate='';
		
		if($this->mepinstance->certificateenddate!=''){
			$enddate=$this->mepinstance->certificateenddate;
		}elseif(intval($this->mepinstance->certificatetime)>0){
			$enddate=date($dateformat,strtotime($coursedate.' + '.$this->mepinstance->certificatetime.' months'));
		}
		$this->setTemplateID($this->mepinstance->certificatetemplate);
		$this->setEmailUser(($this->mepinstance->emailstudent==2)?'y':'n');
		//$this->debug=1;
		$certinfo=$this->addCertificate($this->getMEPCourseID(),$user->email,fullname($user),
			$coursedate,$code,$this->course->shortname,
			$this->mepinstance->coursehours,$enddate,$grade,$teachername);
		//exit;
		if(!$certinfo){
			return false;
		}
	
		$newrec = new Object();
		$newrec->certificateid = $this->mepinstance->id;
		$newrec->userid = $user->id;
		$newrec->timecreated = $certtime;
		$newrec->studentname = fullname($user);
		$newrec->code = $code;
		$newrec->classname = $this->course->fullname;
		$newrec->cwcertid = $certinfo->id;
		$newrec->cwuserid = $certinfo->userid;
		$newrec->cwlink=$certinfo->certificatelinkbv;
		$newrec->reportgrade = $grade;
		$newrec->certdate = $certtime;
		
		$this->DB->insert_record('myeducationpath_issues', $newrec, false);
		
		//increase last number for course.
		$this->mepinstance->lastnumber=$this->mepinstance->lastnumber+1;
		$this->DB->update_record('myeducationpath', $this->mepinstance);
		
		$certrecord = $this->DB->get_record('myeducationpath_issues', array('certificateid'=>$this->mepinstance->id, 'userid'=>$user->id));
		
		if(!$certrecord){
			$this->error='Problem generating new certificate';
			return false;
		}
		
		if($autoissue){
			$this->helper->emailTeachers($certrecord);
			$this->helper->emailOthers($certrecord);
		}
		if($this->mepinstance->emailstudent==1 && !$autoissue){
			$this->helper->emailStudent($certrecord,$user);
		}
		return true;
	}
	function issueDelete($issueid){
		$certrecord = $this->DB->get_record('myeducationpath_issues', array('id'=>$issueid));
		
		if(!isset($certrecord) || $certrecord->id==0) return false;
		
		$this->removeCertificate($certrecord->cwcertid);
	
		$this->DB->delete_records('myeducationpath_issues', array('id'=>$issueid));
		
		return true;
	}
	function getCourseGrade($user=null){
		$this->loadHelper();
		return $this->helper->getCourseGrade($user);
	}
	function getPrintURL($user=null){
		//get link for this user in the course
		//get a certificate info
		$certinfo=$this->getStudentCertificate($user);
		if($certinfo){
			return $certinfo->printlink;
		}
		return '';
	}
	function getStudentCertificate($user=null){
		if(!$user) $user=$this->USER;
		
		$certrecord = $this->DB->get_record('myeducationpath_issues', array('certificateid'=>$this->mepinstance->id, 'userid'=>$user->id));
		if(!$certrecord){
			$this->error='Certificate not found';
			return false;
		}
		$certinfo = $this->getCertificate($certrecord->cwcertid);
		if($certinfo){
			return $certinfo;
		}
		return null;
	}
	function getCertificateImageURL(){
		$certinfo=$this->getStudentCertificate();
		if($certinfo){
			return $certinfo->thumb600link;
		}
		return '';
	}
}

?>