<?php
if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');    ///  It must be included from a Moodle page
}

require_once ($CFG->dirroot.'/course/moodleform_mod.php');
require_once($CFG->dirroot.'/mod/myeducationpath/lib.php');

class mod_myeducationpath_mod_form extends moodleform_mod {

    function definition() {
        global $CFG,$SITE,$DB;

        $mform =& $this->_form;
        
        $MEPWRAPPER = new MEPWrapper($CFG,$SITE,$DB,null,null,null,null);

        $mform->addElement('header', 'general', get_string('general', 'form'));

        $mform->addElement('text', 'name', get_string('modulename', 'myeducationpath'), array('size'=>'64'));
        $mform->addHelpButton('name', 'name', 'myeducationpath');
        if (!empty($CFG->formatstringstriptags)) {
            $mform->setType('name', PARAM_TEXT);
        } else {
            $mform->setType('name', PARAM_CLEAN);
        }
        $mform->addRule('name', null, 'required', null, 'client');

        $this->add_intro_editor(false, get_string('intro', 'myeducationpath'));
        
        //$mform->addHelpButton('intro', 'intro', 'myeducationpath');

        $ynoptions = array( 0 => get_string('no'), 1 => get_string('yes'));
        $vnoptions = array( 0 => get_string('hide'), 1 => get_string('show'));
        
        //$mform->addElement('select', 'visible', get_string('visible'), $vnoptions);
        //$mform->setDefault('visible', 1);
        //$mform->addHelpButton('visible', 'visible', 'myeducationpath');
       
       
        $categories=array(0=>get_string('choosecategory', 'myeducationpath'));
        foreach($MEPWRAPPER->getAllCategories() as $k=>$v) $categories[$k]=$v;

	$hascorrectkey=$MEPWRAPPER->checkAPIKey();
	if(!$hascorrectkey){
		$mform->addElement('header', 'apikeywarning', get_string('apikeywarningheader', 'myeducationpath'));
		$mform->addElement('html', '<div style="color:#800000;">'.get_string('confformnoapikey', 'myeducationpath').'</div>');
	}
	
	
	$mform->addElement('header', 'certificategenerating', get_string('certificategenerating', 'myeducationpath'));
	
	//certificates
        
        $mform->addElement('select', 'allowcertificates', get_string('allowcertificates', 'myeducationpath'), $ynoptions);
        $mform->setDefault('allowcertificates', 1);
        $mform->addHelpButton('allowcertificates', 'allowcertificates', 'myeducationpath');
        
        $mform->addElement('select', 'allowautoissue', get_string('allowautoissue', 'myeducationpath'), $ynoptions);
        $mform->setDefault('allowautoissue', 1);
        $mform->addHelpButton('allowautoissue', 'allowautoissue', 'myeducationpath');
        
        $mform->addElement('text', 'minimumgrade', get_string('minimumgrade', 'myeducationpath'), array('size'=>'4', 'maxsize'=>'20'));
        $mform->setType('minimumgrade', PARAM_TEXT);
        $mform->addHelpButton('minimumgrade', 'minimumgrade', 'myeducationpath');
        
        $emailoptions = array( 0 => get_string('no'), 1 => get_string('emaildirectly', 'myeducationpath'), 2 => get_string('emailremotely', 'myeducationpath'));
        
        $mform->addElement('select', 'emailstudent', get_string('emailstudent', 'myeducationpath'), $emailoptions);
        $mform->setDefault('emailstudent', 0);
        $mform->addHelpButton('emailstudent', 'emailstudent', 'myeducationpath');
        
        $mform->addElement('select', 'emailteachers', get_string('emailteachers', 'myeducationpath'), $ynoptions);
        $mform->setDefault('emailteachers', 0);
        $mform->addHelpButton('emailteachers', 'emailteachers', 'myeducationpath');

        $mform->addElement('text', 'emailothers', get_string('emailothers', 'myeducationpath'), array('size'=>'40', 'maxsize'=>'200'));
        $mform->setType('emailothers', PARAM_TEXT);
        $mform->addHelpButton('emailothers', 'emailothers', 'myeducationpath');
        
        $codeformat = array( 0 => get_string('randomcode', 'myeducationpath'), 1 => get_string('customcodeformat', 'myeducationpath'));
        $mform->addElement('select', 'certificateidformat', get_string('certificateidformat', 'myeducationpath'), $codeformat);
        $mform->setDefault('certificateidformat', $CFG->myeducationpath_certificateidformat);
        $mform->addHelpButton('certificateidformat', 'certificateidformat', 'myeducationpath');
        
        $mform->addElement('text', 'certificatecustomformat', get_string('certificatecustomformat', 'myeducationpath'), array('size'=>'30', 'maxsize'=>'200'));
        $mform->setType('certificatecustomformat', PARAM_TEXT);
        $mform->setDefault('certificatecustomformat', $CFG->myeducationpath_certificatecustomformat);
        $mform->addHelpButton('certificatecustomformat', 'certificatecustomformat', 'myeducationpath');
        
        $mform->addElement('text', 'coursehours', get_string('coursehours', 'myeducationpath'), array('size'=>'6', 'maxsize'=>'10'));
        $mform->setType('coursehours', PARAM_TEXT);
        $mform->addHelpButton('coursehours', 'coursehours', 'myeducationpath');
        
        $mform->addElement('text', 'certificateassigndate', get_string('certificateassigndate', 'myeducationpath'), array('size'=>'6', 'maxsize'=>'10'));
        $mform->setType('certificateassigndate', PARAM_TEXT);
        $mform->addHelpButton('certificateassigndate', 'certificateassigndate', 'myeducationpath');
        
        $mform->addElement('text', 'certificateenddate', get_string('certificateenddate', 'myeducationpath'), array('size'=>'6', 'maxsize'=>'10'));
        $mform->setType('certificateenddate', PARAM_TEXT);
        $mform->addHelpButton('certificateenddate', 'certificateenddate', 'myeducationpath');
        
        $mform->addElement('text', 'certificatetime', get_string('certificatetime', 'myeducationpath'), array('size'=>'6', 'maxsize'=>'10'));
        $mform->setType('certificatetime', PARAM_TEXT);
        $mform->addHelpButton('certificatetime', 'certificatetime', 'myeducationpath');

        $tmpls=$MEPWRAPPER->getTemplates();

        if(is_array($tmpls)){
        	$templates = array();
        	$default='0';
        	foreach($tmpls as $t){
        		$templates[$t->id]=$t->title;
        		if($t->isdefault=='y') $default=$t->id;
        	}
        	$mform->addElement('select', 'certificatetemplate', get_string('certificatetemplate', 'myeducationpath'), $templates);
        	$mform->setDefault('certificatetemplate', $default);
        	$mform->addHelpButton('certificatetemplate', 'certificatetemplate', 'myeducationpath');
        }

	//directory publish
        $mform->addElement('header', 'coursepublishing', get_string('coursepublishing', 'myeducationpath'));
        
        $mform->addElement('html', '<p style="font-size:11px;padding:10px;">'.get_string('publishcoursedescription', 'myeducationpath').'</p>');
        
        $mform->addElement('text', 'mepcourseidmanual', get_string('mepcourseidmanual', 'myeducationpath'), array('size'=>'6', 'maxsize'=>'10'));
        $mform->setType('mepcourseidmanual', PARAM_TEXT);
        $mform->addHelpButton('mepcourseidmanual', 'mepcourseidmanual', 'myeducationpath');
        
        $mform->addElement('html', '<p style="font-size:11px;padding:10px;">'.get_string('publishcoursedescriptionor', 'myeducationpath').'</p>');

        $mform->addElement('select', 'category1', get_string('category', 'myeducationpath').'1', $categories);
        $mform->setDefault('category1', 0);
        $mform->addHelpButton('category1', 'category', 'myeducationpath');
        
        $mform->addElement('select', 'category2', get_string('category', 'myeducationpath').'2', $categories);
        $mform->setDefault('category2', 0);
        $mform->addHelpButton('category2', 'category', 'myeducationpath');
        
        $mform->addElement('select', 'category3', get_string('category', 'myeducationpath').'3', $categories);
        $mform->setDefault('category3', 0);
        $mform->addHelpButton('category3', 'category', 'myeducationpath');
        
        $mform->addElement('text', 'tags', get_string('tags', 'myeducationpath'), array('size'=>'50'));
        $mform->addHelpButton('tags', 'tags', 'myeducationpath');
        $mform->setType('tags', PARAM_TEXT);
        
        $mform->addElement('text', 'imageurl', get_string('imageurl', 'myeducationpath'), array('size'=>'60'));
        $mform->addHelpButton('imageurl', 'imageurl', 'myeducationpath');
        $mform->setType('imageurl', PARAM_TEXT);
        
        $this->standard_coursemodule_elements();

        $mform->setDefault('visible', 1);
        $mform->addHelpButton('visible', 'visible', 'myeducationpath');
        
        $this->add_action_buttons();

    }
}