<?php // $Id: version.php

require_once('../../config.php');
require_once('lib.php');

$id = required_param('id', PARAM_INT);    // Course Module ID
$action = optional_param('action', '', PARAM_ALPHA);
$message = optional_param('message', '', PARAM_TEXT);

list($cm,$course,$mepinstance,$context) = myeducationpath_get_context($id,$error);
if(!$cm){
	print_error($error);
}

require_login($course->id, true, $cm);

require_capability('mod/myeducationpath:view', $context);

if (!has_capability('mod/myeducationpath:manage', $context)) {//this is teacher. redirect to report page
	$url = new moodle_url('/mod/myeducationpath/view.php', array('id' => $cm->id));
	redirect($url->out(false));
}

add_to_log($course->id, 'myeducationpath', 'view', "report.php?id=$cm->id", $mepinstance->id, $cm->id);
$completion=new completion_info($course);
$completion->set_module_viewed($cm);

global $MEPWRAPPER;
$MEPWRAPPER = new MEPWrapper($CFG,$SITE,$DB,$USER,$course,$mepinstance,$cm);

if($CFG->myeducationpath_enableintegration=='no') $action='';
if($action=='addtomep' || $action=='refresh'){//add or update the comment
	$message='';
	if(!$MEPWRAPPER->exportCourse()){
		$message='ERROR: '.$MEPWRAPPER->error;
	}
	$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id,'message'=>$message));
	redirect($url->out(false));
}
if($action=='remove'){
	$isseuid=optional_param('isseuid', '', PARAM_INT);
	
	$MEPWRAPPER->issueDelete($isseuid);

	$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id));
	redirect($url->out(false));
    
}elseif($action=='issue' || $action=='reissue'){
	$studentid=optional_param('userid', '', PARAM_INT);
	
	if(!$MEPWRAPPER->issueCertificate($studentid,false)){
		$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id,'message'=>$MEPWRAPPER->error));
	}else{
		$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id));
	}
	redirect($url->out(false));
	
}elseif($action=='export'){
	$format = optional_param('format', '', PARAM_ALPHA);
	
	$groupmode = groups_get_activity_groupmode($cm);
	
	$sqlsort = 's.studentname ASC';
	$users = myeducationpath_get_issues($mepinstance->id, $sqlsort, $groupmode, $cm);
	
	if ($format == "ods") {
		myeducationpath_report_export_spreadsheet($users,$course,$mepinstance,'ods');
	}
	if ($format == "xls") {
		myeducationpath_report_export_spreadsheet($users,$course,$mepinstance,'xls');
	}
	if ($format == "txt") {
		myeducationpath_report_exportTXT($users,$course,$mepinstance);
	}
	exit;
}

// Initialize $PAGE, compute blocks
$PAGE->set_url('/mod/myeducationpath/report.php', array('id' => $cm->id));
$PAGE->set_context($context);
$PAGE->set_cm($cm);

$url = new moodle_url('/mod/myeducationpath/report.php');
$thisurl=$url->out(false);

$error=0;

$courseregistered=false;
$coursecanberegistered=false;

$mepcourse = $MEPWRAPPER->getMEPCourse();

if(!$mepcourse){
	$coursecanberegistered=true;
	$error=$MEPWRAPPER->getErrorCode();
}elseif($mepcourse){
	$courseregistered=true;
}

myeducationpath_view_header($course, $mepinstance, $cm,$message, true);

//find what is the status of the view
$status='report';
if($CFG->myeducationpath_apikey==''){
	$status='nokeyprovided';
}elseif($CFG->myeducationpath_enableintegration=='no'){
	$status='disableintegration';
}elseif(!$mepcourse && $error==1){
	$status='wrongapikey';
}elseif(!$mepcourse && $error==2){
	$status='errorexportcourse';
}elseif(!$mepcourse && $coursecanberegistered){
	$status='needsconfirmation';
}elseif($courseregistered){
	$status='report';
}elseif(!$mepcourse){
	$status='error';
}

//show content
if($status=='nokeyprovided'){
	echo '<p align="center" style="fond-weight:bold;font-size:16px;">The activity is not active yet. API key is not saved in the activity settings. '.
	'The site administrator can do this in Site administration->Plugins->Activity modules->My Education Path</p><p></p>';
	
}elseif($status=='disableintegration'){
	echo '<p align="center" style="fond-weight:bold;font-size:16px;">The activity is not active. Integration with MyEducationPath is disabled in system settings. '.
	'The site administrator can enable this in Site administration->Plugins->Activity modules->My Education Path</p><p></p>';
}elseif($status=='report'){
	//show certificates 
	$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id,'action'=>'refresh'));
	$refreshlink=$url->out(false);

	?>
	<style type="text/css">
	.commentslist td {border:1px solid #ccc;}
	.integrationstatus h3 span.active {color:#002E00;}
	.integrationstatus h3 span.disabled {color:#510000;}
	</style>
	<table width="100%" border="0">
	<tr>
	<td class="integrationstatus" valign="top">
		<h2>Status of the activity integration with MyEducationPath.com</h2>
		<h3 ><a href="#comments">Feedback and Rating</a>: <span class="active">Active</span></h3>
		<h3 ><a href="#certificates">Certificates</a>: <?php if($mepinstance->allowcertificates==1){ ?><span  class="active">Active</span><?php }else{ ?><span class="disabled">Disabled</span><?php } ?></h3>
		<p>The course page on the MyEducationPath.com directory - <a target="_blank" href="<?php echo $mepcourse->coursedetails?>"><?php echo $mepcourse->name?></a></p>
		<p>If you changed something in this course settings and description then click <a href="<?php echo $refreshlink?>">Refresh information</a> 
		to have updated data on this course page in the directory.</p>
		<?php if($mepcourse->visible=='n'){ ?>
			<p>The course is <b>not visible</b> in the MyEducationPath.com directory. To publish it you have to login to your 
			Education Provider account on <a href="http://myeducationpath.com" target="_blank">MyEducationPath</a> and make it visible there.</p>
		<?php }
		if($mepinstance->allowcertificates==1){
		?>
		<p>&nbsp;</p>
		<p>&nbsp;</p>
		<h2>Example view of the certificate (image to the right)</h2>
		<p>You can not change the view of the certificate with this activity. 
		To do this, please, go to MyEducationPath.com and login to your issuer account. There is the tool to edit the certificate template</p>
		<?php } ?>
	</td>
	<?php
	if($mepinstance->allowcertificates==1){
		$info=$MEPWRAPPER->getAccountInfo();
		
		?>
		<td valign="top" width="620">
			<p align="center"><img src="<?php echo $info->democertificate;?>"></p>
		</td>
		<?php
	}
	?>
	</tr>
	</table>
	<p><hr></p>
	<?php
	
	if($mepinstance->allowcertificates==1){
		myeducationpath_printCertificateInformation($mepinstance,$course,$cm);
	}else{
		?>
		<h2><a name="certificates"></a>Certificates</h2>
		<p>Certificates functionality is not enabled in this activity. If you want to enable it then edit the activity.</p>
		<?php
	
	}
	//show existent comments
	$comments=myeducationpath_get_comments($course,$mepinstance);
	
	?>
	
	
	<p><hr></p>
	<h2><a name="comments"></a>Students' comments and ratings</h2>
	<?php
	if(count($comments)>0){
		?>
		<table class="commentslist">
		<tr>
		<th>Student</th>
		<th>Comment</th>
		<th>Rating</th>
		</tr>
		<?php
		foreach($comments as $comment){
			?>
			<tr>
			<td valign="top"><a href="<?php $url = new moodle_url('/user/view.php', array('id' => $comment->userid,'course'=>$course->id)); echo $url->out(false);?>"><?php echo $comment->user?></a></td>
			<td><div style="white-space:pre-wrap;"><?php echo $comment->mepcomment?></div></td>
			<td><?php if($comment->meprating==0){ echo 'No rating';}else{ echo $comment->meprating.' of 5';}?></td>
			</tr>
			<?php
		}
		?>
		</table>
		<?php
	}else{
		echo '-- no feedback yet --';
	}
}elseif($status=='needsconfirmation'){
	//show export button
	?>
	<p align="center" style="fond-weight:bold;font-size:16px;">The course is not registered in 
		<a href="http://MyEducationPath.com/courses">http://MyEducationPath.com/courses</a> directory. You can register it now. Just click on the button below.</p>
	<?php
	if($mepinstance->allowcertificates==1){
		?>
		<p align="center" style="font-size:13px;">To issue certificates for students you need to publish the course in the MyEducationPath directory</p>
		<?php
	}
	?>
	<div align="center">
	<form method="GET" action="<?php echo $thisurl?>">
	<input type="hidden" name="id" value="<?php echo $id?>">
	<input type="hidden" name="action" value="addtomep">
	<input type="submit" value="Yes, register the course on MyEducationPath.com" style="padding:5px;font-size:18px;">
	</form>
	</div>
	<?php
}else{
	echo '<p align="center" style="fond-weight:bold;font-size:16px;">Error: '.$errormessage.'.</p><p></p>';
}


//echo '<p align="center" style="border:1px solid gray;padding:20px;"><a href="http://myeducationpath.com/" target="_blank">MyEducationPath.com</a> helps you navigate in e-Learning sources. We try to systematize information about online education. You can use this service to find online courses, share comments and reviews. Our mission is to help people to build a personal education path using free or cheap online courses as alternative to traditional higher education. We help to find free alternatives to expensive college/university courses.</p>';

echo $OUTPUT->footer($course);
exit;

function myeducationpath_printCertificateInformation($mepinstance,$course,$cm){
	global $CFG,$MEPWRAPPER,$OUTPUT;
	
	$groupmode = groups_get_activity_groupmode($cm);
	$users = myeducationpath_get_issues($mepinstance->id, 's.studentname ASC', $groupmode, $cm);
	
	$students=myeducationpath_get_course_students($mepinstance,$cm);

	echo '<h2><a name="certificates"></a>Certificates</h2>';

	if(!$users) {
		echo('<h3>There are no issued certificates</h3>');
	}else{
		$table = new html_table();
		$table->width = "95%";
		$table->tablealign = "center";
		$table->head  = array (get_string('awardedto', 'myeducationpath'), get_string('receiveddate', 'myeducationpath'),
			get_string('grade','myeducationpath'), get_string('code', 'myeducationpath'),
			get_string('link', 'myeducationpath'),get_string('reportdelete', 'myeducationpath'));
		
		$table->align = array ("LEFT", "LEFT", "CENTER", "CENTER");
		foreach ($users as $user) {
			$name = $OUTPUT->user_picture($user).'<a href="'.$CFG->wwwroot.'/user/view.php?id='.$user->id.'&course='.$course->id.'">'.$user->studentname.'</a>';
			//$date = userdate($user->certdate).myeducationpath_print_user_files($certificate, $user->id, $context->id);
			$date = userdate($user->certdate);
			if ($user->reportgrade != null) {
			    $grade = $user->reportgrade;
			} else {
			    $grade = get_string('notapplicable','myeducationpath');
			}
			$code = $user->code;
			
			$options = array();
			$options["id"] = "$cm->id";
			$options["code"] = $user->code;
			$options["userid"] = (!isset($user->userid))?$user->id:$user->userid;
			$options["isseuid"] = $user->issueid;
			$options["action"] = "remove";
			$delete=$OUTPUT->single_button(new moodle_url("report.php", $options), '[DEL]');
			
			$link='<a href="'.$user->cwlink.'" target="_blank">View certificate</a>';
			
			$options = array();
			$options["id"] = "$cm->id";
			$options["code"] = $user->code;
			$options["userid"] = (!isset($user->userid))?$user->id:$user->userid;
			$options["isseuid"] = $user->issueid;
			$options["action"] = "remove";
			$delete=$OUTPUT->single_button(new moodle_url("report.php", $options), '[DEL]');
			
			$table->data[] = array ($name, $date, $grade, $code, $link,$delete);
		}
		
		echo '<br />';
		echo html_writer::table($table);
		
		//now give links for downloading spreadsheets.
		echo "<br />\n";
		echo "<center><table class=\"downloadreport\"><tr>\n";
		echo "<td>";
		$downloadoptions = array();
		$options = array();
		$options["id"] = "$cm->id";
		$options["action"] = "export";
		$options["format"] = "ods";
		echo $OUTPUT->single_button(new moodle_url("report.php", $options), get_string("downloadods"));
		
		echo "</td><td>";
		$options["format"] = "xls";
		echo $OUTPUT->single_button(new moodle_url("report.php", $options), get_string("downloadexcel"));
		echo "</td><td>";
		$options["format"] = "txt";
		echo $OUTPUT->single_button(new moodle_url("report.php", $options), get_string("downloadtext"));
		echo "</td></tr></table></center>";
	}
	
	if($students){
		echo '<h2>'.get_string('studentwithoutcert', 'myeducationpath').'</h2>';
		
		$table = new html_table();
		$table->width = "95%";
		$table->tablealign = "center";
		$table->head  = array (get_string("fullname"), get_string('grade','myeducationpath'), get_string('issuecertificate','myeducationpath'));
		$table->align = array ("LEFT", "LEFT", "CENTER");
		foreach ($students as $student) {
			$name = $OUTPUT->user_picture($student).'<a href="'.$CFG->wwwroot.'/user/view.php?id='.$student->id.'&course='.$course->id.'">'.fullname($student).'</a>';
			$grade = $MEPWRAPPER->getCourseGrade($student);
			$grade=$grade->percentage;
			$options = array();
			$options["id"] = "$cm->id";
			$options["userid"] = $student->id;
			$options["action"] = "issue";
			
			$issue=$OUTPUT->single_button(new moodle_url("report.php", $options), '[ ISSUE A CERTIFICATE ]');
			$table->data[] = array ($name, $grade,$issue);
		}
		
		echo '<br />';
		echo html_writer::table($table);
	}

	
}

function myeducationpath_report_export_spreadsheet($users,$course,$certificate,$format='xls'){
	global $CFG;
	
	if($format=='xls'){
		require_once("$CFG->libdir/excellib.class.php");
		$filename = clean_filename("$course->shortname ".strip_tags(format_string($certificate->name,true))).'.xls';
		$workbook = new MoodleExcelWorkbook("-");
	}else{
		require_once("$CFG->libdir/odslib.class.php");
		$filename = clean_filename("$course->shortname ".strip_tags(format_string($certificate->name,true))).'.ods';
		$workbook = new MoodleODSWorkbook("-");
	}
	
	$workbook->send($filename);

	$myxls = $workbook->add_worksheet(get_string('report', 'myeducationpath'));
	
	/// Print names of all the fields
	$myxls->write_string(0,0,get_string("lastname"));
	$myxls->write_string(0,1,get_string("firstname"));
	$myxls->write_string(0,2,get_string("idnumber"));
	$myxls->write_string(0,3,get_string("group"));
	$myxls->write_string(0,4,get_string('receiveddate', 'myeducationpath'));
	$myxls->write_string(0,5,get_string('grade','myeducationpath'));
	$myxls->write_string(0,6,get_string('code', 'myeducationpath'));
	$myxls->write_string(0,7,get_string('link', 'myeducationpath'));
	
	
	/// generate the data for the body of the spreadsheet
	$i=0;
	$row=1;
	if ($users) {
	    foreach ($users as $user) {
		$myxls->write_string($row,0,$user->lastname);
		$myxls->write_string($row,1,$user->firstname);
		$studentid=(!empty($user->idnumber) ? $user->idnumber : " ");
		$myxls->write_string($row,2,$studentid);
		$ug2 = '';
		if ($usergrps = groups_get_all_groups($course->id, $user->id)) {
		    foreach ($usergrps as $ug) {
			$ug2 = $ug2. $ug->name;
		    }
		}
		$myxls->write_string($row,3,$ug2);
		$myxls->write_string($row,4,userdate($user->certdate));
		if ($user->reportgrade != null) {
		    $grade = $user->reportgrade;
		} else {
		    $grade = get_string('notapplicable','myeducationpath');
		}
		$myxls->write_string($row,5,$grade);
		$myxls->write_string($row,6,$user->code);
		//if($CFG->myeducationpath_integration!='simple'){
			$myxls->write_string($row,7,$user->cwlink);
		//}
		$row++;
	    }
	    $pos=6;
	}
	/// Close the workbook
	$workbook->close();
	exit;
}

function myeducationpath_report_exportTXT($users,$course,$certificate){
	$filename = clean_filename("$course->shortname ".strip_tags(format_string($certificate->name,true))).'.txt';

	header("Content-Type: application/download\n");
	header("Content-Disposition: attachment; filename=\"$filename\"");
	header("Expires: 0");
	header("Cache-Control: must-revalidate,post-check=0,pre-check=0");
	header("Pragma: public");

	/// Print names of all the fields

	echo get_string("firstname")."\t".get_string("lastname") . "\t". get_string("idnumber") . "\t";
	echo get_string("group"). "\t";
	echo get_string('receiveddate', 'myeducationpath'). "\t";
	echo get_string('grade','myeducationpath'). "\t";
	echo get_string('code', 'myeducationpath'). "\t";
	echo get_string('link', 'myeducationpath'). "\n";
	
	/// generate the data for the body of the spreadsheet
	$i=0;
	$row=1;
	if ($users) foreach ($users as $user) {
		echo $user->lastname;
		echo "\t".$user->firstname;
		$studentid = " ";
		if (!empty($user->idnumber)) {
		$studentid = $user->idnumber;
		}
		echo "\t". $studentid."\t";
		$ug2 = '';
		if ($usergrps = groups_get_all_groups($course->id, $user->id)) {
		foreach ($usergrps as $ug) {
		    $ug2 = $ug2. $ug->name;
		}
		}
		echo $ug2. "\t";
		echo userdate($user->certdate)."\t";
		if ($user->reportgrade != null) {
		$grade = $user->reportgrade;
		} else {
		$grade = get_string('notapplicable','myeducationpath');
		}
		echo $grade."\t";
		echo $user->code."\t";
		echo $user->cwlink."\n";
		$row++;
	}
	exit;
}