<?php

if(!class_exists('admin_setting_justhtml')){
class admin_setting_justhtml extends admin_setting_heading{
	public function __construct($text) {
		parent::__construct('textfield', 'nothing', $text);
	}
	public function output_html($data, $query='') {
		global $OUTPUT;
		return $OUTPUT->box(highlight($query, markdown_to_html($this->description)), 'generalbox formsettingheading');
	}
	//this function is needed to show configuration help after installation
	public function get_setting() {
		global $CFG;
		if(isset($CFG->myeducationpath_enableintegration)) return true;
		return null;
	}
}
}

if ($ADMIN->fulltree) {

	$settings->add(new admin_setting_justhtml(get_string('settingsdescription', 'myeducationpath')));

	$settings->add(new admin_setting_configtext('myeducationpath_apikey', get_string('apikey', 'myeducationpath'),
		get_string('configapikey', 'myeducationpath'), ''));
	
        $options = array();
	$options['yes']      = get_string('yes');
	$options['no'] = get_string('no');
	$settings->add(new admin_setting_configselect('myeducationpath_enableintegration',
		get_string('enableintegration', 'myeducationpath'),
		get_string('configenableintegration', 'myeducationpath'), 'yes', $options));
	
	$options = array( 0 => get_string('randomcode', 'myeducationpath'), 1 => get_string('customcodeformat', 'myeducationpath'));
	$settings->add(new admin_setting_configselect('myeducationpath_certificateidformat', get_string('certificateidformat', 'myeducationpath'),
                       get_string('configcertificateidformat', 'myeducationpath'), 0, $options));
        
        $settings->add(new admin_setting_configtext('myeducationpath_certificatecustomformat', get_string('certificatecustomformat', 'myeducationpath'),
        	get_string('configcertificatecustomformat', 'myeducationpath'), 'CW:%Y-%M-%D-%C-%N'));
        
        $settings->add(new admin_setting_configtext('myeducationpath_dateformat', get_string('dateformat', 'myeducationpath'),
                       get_string('configdateformat', 'myeducationpath'), 'F d, Y'));
        
}

