<?php 

require_once('../../config.php');
require_once('lib.php');

$id = required_param('id', PARAM_INT);    // Course Module ID
$action = optional_param('action', '', PARAM_ALPHA);
$message = optional_param('message', '', PARAM_TEXT);

list($cm,$course,$mepinstance,$context) = myeducationpath_get_context($id,$error);
if(!$cm){
	print_error($error);
}

require_login($course->id, true, $cm);

require_capability('mod/myeducationpath:view', $context);

if (has_capability('mod/myeducationpath:manage', $context)) {//this is teacher. redirect to report page
	$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id));
	redirect($url->out(false));
}

add_to_log($course->id, 'myeducationpath', 'view', "view.php?id=$cm->id", $mepinstance->id, $cm->id);

$completion=new completion_info($course);
$completion->set_module_viewed($cm);

global $MEPWRAPPER;
$MEPWRAPPER = new MEPWrapper($CFG,$SITE,$DB,$USER,$course,$mepinstance,$cm);

$url = new moodle_url('/mod/myeducationpath/view.php');
$thisurl=$url->out(false);

//=========== ACTIONS =================
if($action=='comment'){//add or update the comment
	
	$rating = optional_param('rating', '', PARAM_INT);
	$comment = optional_param('comment', '', PARAM_TEXT);

	if(!$MEPWRAPPER->addComment($comment,$rating)){
		$url = new moodle_url('/mod/myeducationpath/view.php', array('id' => $cm->id,'message'=>$MEPWRAPPER->error));
	}else{
		$url = new moodle_url('/mod/myeducationpath/view.php', array('id' => $cm->id));
	}
	redirect($url->out(false));
	
}elseif($action=='generate'){
	if(!$MEPWRAPPER->issueCertificate($USER->id,true)){
		$message=$MEPWRAPPER->error;
		if($MEPWRAPPER->errorstatus=='error_limits'){
			$message='Problem generating certificate. Contact teacher/instructor/administrator';
		}
		$url = new moodle_url('/mod/myeducationpath/view.php', array('id' => $cm->id,'message'=>$message));
	}else{
		$url = new moodle_url('/mod/myeducationpath/report.php', array('id' => $cm->id));
	}
	redirect($url->out(false));
	exit;
}elseif($action=='print'){
	$link=$MEPWRAPPER->getPrintURL();
	if($link!=''){
		$url = new moodle_url($link);
		redirect($url->out(false));
	}
	$url = new moodle_url('/mod/myeducationpath/view.php', array('id' => $cm->id,'message'=>$MEPWRAPPER->error));
	redirect($url->out(false));
}

// Initialize $PAGE, compute blocks
$PAGE->set_url('/mod/myeducationpath/view.php', array('id' => $cm->id));
$PAGE->set_context($context);
$PAGE->set_cm($cm);

//get this user comment from DB
$comment = $DB->get_record('myeducationpath_comments', array('courseid'=>$course->id, 'userid'=>$USER->id));

$mepcourse = $MEPWRAPPER->getMEPCourse();

myeducationpath_view_header($course, $mepinstance, $cm , $message);

//find what is the status of the view
$status='askcomment';
if($CFG->myeducationpath_apikey==''){
	$status='nokeyprovided';
}elseif($CFG->myeducationpath_enableintegration=='no'){
	$status='disableintegration';
}elseif(!$mepcourse){
	$status='coursenotregistered';
}elseif($comment){
	$status='updatecomment';
}

//show content
if($status=='nokeyprovided'){
	echo '<p align="center" style="fond-weight:bold;font-size:16px;">The activity is not active yet. Contact the course teacher.</p><p></p>';
	
}elseif($status=='disableintegration' || $status=='coursenotregistered'){
	echo '<p align="center" style="fond-weight:bold;font-size:16px;">The activity is not active. Contact the course teacher.</p><p></p>';
}else{
	
	?>
	<style type="text/css">
	.ratingselector input {margin-left:10px;}
	.ratingselector span.ratinglabel {font-weight:bold;}
	.feedbacksavebutton {padding:15px;font-size:17px;font-weight:bold;}
	
	#certificatediv {float:left;width:630px;}
	#feedbackdiv {float:left;width:300px;padding-left:20px;padding-top:50px;}
	</style>
	<?php
	if($mepinstance->allowcertificates==1){
		
	$certificate = $DB->get_record('myeducationpath_issues', array('certificateid'=>$mepinstance->id, 'userid'=>$USER->id));
	$grade=$MEPWRAPPER->getCourseGrade();

	?>
	<div id="certificatediv">
	<p align="center"><?php echo get_string('currentgrade', 'myeducationpath');?> : <?php echo $grade->percentage;?></p>
	<?php


	if($certificate){
		?>
		<table align="center"><tr><td  valign="top">
		<h1 align="center"><a href="<?php echo $certificate->cwlink;?>" target="_blank"><?php echo get_string('viewyourcertificateoncw', 'myeducationpath');?></a></h1>
		
		</td><td width="100" valign="top" style="padding-left:40px;">
		<a href="<?php echo $CFG->wwwroot.'/mod/myeducationpath/view.php?id='.$cm->id.'&action=print';?>" target="_blank" title="Print certificate">
			<img src="<?php echo $CFG->wwwroot;?>/mod/myeducationpath/images/print.png" alt="print certificate"></a>
		</td></tr></table>
		<?php
		$link=$MEPWRAPPER->getCertificateImageURL();
		if($link!=''){
		?>
		<center><img src="<?php echo $link;?>" ></center>
		<?php
		}
	}elseif( ($grade->points >= $mepinstance->minimumgrade || $mepinstance->minimumgrade<1) && $mepinstance->allowautoissue==1){
		
		echo '<center>';
		$t=get_string('getcertificate', 'myeducationpath');
		$button = new single_button(new moodle_url('/mod/myeducationpath/view.php', array('id'=>$cm->id, 'action'=>'generate')),$t, 'get');
		echo $OUTPUT->render($button);
		echo '</center>';
		
	}elseif($grade->points<$mepinstance->minimumgrade && $mepinstance->allowautoissue==1){
		echo '<p align="center">'.sprintf(get_string('musthavesomegrade', 'myeducationpath'),$mepinstance->minimumgrade).'</p>';
	}else{
		echo '<p align="center">'.get_string('youhavenocertificateissued', 'myeducationpath').'</p>';
	}
	?>
	</div>
	
	<?php
	}
	?>
	
	<div id="feedbackdiv">
	<?php
	if($mepinstance->allowcertificates==1 && $certificate){
		?>
		<p style="text-align:justify;"><?php echo get_string('whattodowithcertificate', 'myeducationpath');?></a></p>
		<p>&nbsp;</p>
		<p>&nbsp;</p>
		<?php
	}
	?>
	<h3>Course Feedback</h3>
	<table width="100%" border="0">
	<tr>
	<td valign="top" >
	<p>Your feedback will be visible on the online courses directory <a href="http://myeducationpath.com/courses/" target="_blank">MyEducationPath.com</a><br>
	This course page on the directory - <a target="_blank" href="<?php echo $mepcourse->coursedetails?>"><?php echo $mepcourse->name?></a></p>
	<?php
	$rating=0;
	$commenttext='';
	if($status=='updatecomment'){
		?>
		<h2>Your comment and rating on the course</h2>
		<p>Rating: <b><?php if($comment->meprating==0){ echo 'No rating';}else{ echo $comment->meprating.' of 5';}?></b></p>
		<p>Comment:<br>
		<div style="white-space:pre-wrap;"><?php echo $comment->mepcomment?></div>
		</p>
		<p><hr><div id="editfeedbackdiv">
			<a href="javascript:void(0)" onclick="document.getElementById('mepcommentformdiv').style.display='block';document.getElementById('editfeedbackdiv').style.display='none';">
			Edit your feedback</a>
		</div></p>
		<?php
		$rating=$comment->meprating;
		$commenttext=$comment->mepcomment;
	}
	?>
	<div id="mepcommentformdiv" <?php if($status=='updatecomment'){ ?>style="display:none;"<?php } ?>>
	<form action="<?php echo $thisurl?>" method="POST">
	<input type="hidden" name="id" value="<?php echo $id?>">
	<input type="hidden" name="action" value="comment">
	
	<p><div class="ratingselector">
	<span style="padding-right:30px;">Rate course:<br>(1 - bad ... 5 - excellent)</span> <br>
	<input type="radio" name="rating" value="1" <?php if($rating==1) echo 'checked';?>> <span class="ratinglabel">1</span>
	<input type="radio" name="rating" value="2" <?php if($rating==2) echo 'checked';?>> <span class="ratinglabel">2</span>
	<input type="radio" name="rating" value="3" <?php if($rating==3) echo 'checked';?>> <span class="ratinglabel">3</span>
	<input type="radio" name="rating" value="4" <?php if($rating==4) echo 'checked';?>> <span class="ratinglabel">4</span>
	<input type="radio" name="rating" value="5" <?php if($rating==5) echo 'checked';?>> <span class="ratinglabel">5</span>
	<input type="radio" name="rating" value="0" <?php if($rating==0) echo 'checked';?>> <span>don't rate</span>
	</div>
	</p>
	<p>
	Your comments about the course.<br>
	<textarea rows="10" cols="40" name="comment"><?php echo $commenttext?></textarea>
	</p>
	
	<input type="submit" value="<?php if($status=='updatecomment'){ ?>Update<?php }else{ ?>Add<?php } ?> feedback" class="feedbacksavebutton">
	
	<?php if($status=='updatecomment'){ ?><span style="margin-left:60px;">
	<a href="javascript:void(0)" onclick="document.getElementById('mepcommentformdiv').style.display='none';document.getElementById('editfeedbackdiv').style.display='block';">
			Cancel</a>
	</span><?php } ?>
	</form>
	</div>
	</td>
	</tr>
	</table>
	</div>
	
	<div style="clear: both;"> </div>
	<?php
}

echo $OUTPUT->footer($course);
exit;
